package com.agilex.healthcare.veteranappointment.dataservice

import com.agilex.healthcare.veteranappointment.domain.DisabledFeatures
import spock.lang.Specification
import spock.lang.Unroll

class DisabledFeatureServiceSpec extends Specification {
    def disabledFeatureService = new DisabledFeatureService(Stub(DisabledFeatures) {
        getDisabledFeatures() >> [ 'disabledFeature1', 'disabledFeature2' ]
    })

    @Unroll
    def 'containsDisabledFeature(String) returns #expectedValue when a feature is #status'() {
        expect:
        disabledFeatureService.containsDisabledFeature(feature) == expectedValue

        where:
        feature            | expectedValue | status
        'enabledFeature'   | false         | 'enabled'
        'disabledFeature1' | true          | 'disabled'
    }
}
